/* Constantes pour les broches */
const byte TRIGGER_PIN = 10;// Broche TRIGGER
const byte ECHO_PIN = 9;    // Broche ECHO
const byte BUZZER = 2;      // Broche du BUZZER

void setup() {
  /* Initialise les broches */
  pinMode(TRIGGER_PIN, OUTPUT);
  digitalWrite(TRIGGER_PIN, LOW); //Initialement éteint
  pinMode(ECHO_PIN, INPUT);
  pinMode(BUZZER, OUTPUT);

}

void loop() {
  /*Détermination de la durée de l'aller/retour */
  digitalWrite(TRIGGER_PIN, HIGH);
  delayMicroseconds(10);
  digitalWrite(TRIGGER_PIN, LOW);
  long duree = pulseIn(ECHO_PIN, HIGH);
  
  /*Calcul de la fréquence tq duree = 2*T. La distance correspond à la moitié de la longueur d'onde*/
  float frequence = 1000000 / duree;

  tone(BUZZER, frequence);
  delay(10);                  // Pause avant de refaire une mesure sinon risque de variation de fréquence 10ms>T !!!
}
