#include <Servo.h>
Servo monServomoteur;
// Initialise les variables valCapteur, DIO_Buzzer...
int valCapteur = 0 ;
int valCapteurMax ;
int valSeuilVerre;
int valSeuilRemplis;
char PinLedG = 5 ;
char PinLedR = 6 ;
boolean etatRob ; //controle l'état ouvert ou fermé du robinet
boolean etatRempl; //controle le remplissage

void seuil() {
  valCapteurMax = analogRead (A0);
  valSeuilVerre = 0.95 * valCapteurMax;
  valSeuilRemplis = 0.5 * valCapteurMax;
  //  valCapteurMax = 1000;
  //  valSeuilVerre = 950;
  //  valSeuilRemplis = 500;
}

// Fonction appelée au démarrage de la carte Arduino
void setup() {

  // Attache le servomoteur à la broche D9
  monServomoteur.attach(9);
  Serial.begin(9600);
  seuil();
}



// Fonction appelée en boucle tant que la carte Arduino est alimentée
void loop() {
  // Mesure la tension sur la broche A0, valeur variant de 0 à 1023
  valCapteur = analogRead(A0) ;

  //On évalue une seule fois les seuils

  if (etatRempl == 0)  {
    if ((valCapteur < valCapteurMax + 20) or (valCapteur > valCapteurMax - 20)) {
      // Si le tube est vide (0) et pas mis, il ne se passe rien
      digitalWrite(PinLedR, HIGH);
      digitalWrite(PinLedG, HIGH);
      monServomoteur.write(0);
    }

    if ((valCapteur < valSeuilVerre) and (valCapteur > valSeuilRemplis)) {
      // Si le tube est vide (0) et placé, on attend 5s et on tourne le robinet et on dit que le tube se remplit. Le robinet est ouvert (1)
      if (etatRob == 0) {
        delay(5000);
        etatRob = 1;
      }
      else {
        digitalWrite(PinLedR, HIGH);
        digitalWrite(PinLedG, LOW);
        monServomoteur.write(80);
        delay(15); //Permet d'éviter les tremblements du moteur
      }
    }

    if (valCapteur < valSeuilRemplis) {
      // Si le tube est rempli, on ferme le robinet et on dit que le tube est rempli (1)
      monServomoteur.write(0);
      digitalWrite(PinLedR, LOW);
      digitalWrite(PinLedG, HIGH);
      etatRempl = 1; //Variable qui permet de sortir de la boucle

    }
  }
  else {
    // Si le tube est rempli jusqu'à la limite, on le retire
    etatRempl = 0; //Variable qui permet d'entrer dans la boucle
    etatRob = 0;
    delay(5000);
  }

}
