/*
 
  Original Author: David Souder - souder.d@gmail.com
  Date de dernire modification : 11/02/2014
  Licence : propritaire - DuinEDU.com tous droits rservs. 
  update: Olivier Guiter - Add multiple leds support 
   
  
*/

#ifndef Duinoedu_LedControlAdd_H
#define Duinoedu_LedControlAdd_H

#if defined(ARDUINO) && ARDUINO >= 100
#include "Arduino.h"
#else
#include <WProgram.h>
#include "Wire.h"
#endif

#include <LedControl.h>

// Paramtrage par dfaut
	#define EDU_LEDCONTROL_DIN 2
	#define EDU_LEDCONTROL_CS  3
	#define EDU_LEDCONTROL_CLK 4
	#define EDU_LEDCONTROL_DISP 1
	#define EDU_LEDCONTROL_DEFAULT_DELAY 50
	#define EDU_LEDCONTROL_MAXDISP 5

// ETIQUETTE PAR DEFAUT
	#define CODE_DES_MOTIFS //do{const byte IMAGES[][8]={{B00000000,B11101001,B10101010,B10101100,B10101010,B11101001,B00000000,B00000000}};const int IMAGES_LEN = sizeof(IMAGES)/8;}while(0)
	#define VIDE

// Motifs pr-enregistrs	
	#define EDU_LEDCONTROL_FLECHE_AVANT 		B00011000,B00111100,B01111110,B11111111,B00111100,B00111100,B00111100,B00111100
	#define EDU_LEDCONTROL_FLECHE_ARRIERE 		B00111100,B00111100,B00111100,B00111100,B11111111,B01111110,B00111100,B00011000
	#define EDU_LEDCONTROL_FLECHE_DROITE 		B00001000,B00001100,B11111110,B11111111,B11111111,B11111110,B00001100,B00001000
	#define EDU_LEDCONTROL_FLECHE_GAUCHE 		B00010000,B00110000,B01111111,B11111111,B11111111,B01111111,B00110000,B00010000
	#define EDU_LEDCONTROL_SENS_INTERDIT 		B00111100,B01000010,B10000001,B10111101,B10111101,B10000001,B01000010,B00111100
	#define EDU_LEDCONTROL_SENS_INTERDIT 		B00111100,B01000010,B10000001,B10111101,B10111101,B10000001,B01000010,B00111100
	#define EDU_LEDCONTROL_CROIX				B10000001,B01000010,B00100100,B00011000,B00011000,B00100100,B01000010,B10000001
	#define EDU_LEDCONTROL_COEUR				B00000000,B01100110,B10011001,B10000001,B10000001,B01000010,B00100100,B00011000
	#define EDU_LEDCONTROL_SABLIER				B01111110,B00100100,B00111100,B00011000,B00011000,B00111100,B00111100,B01111110
	#define EDU_LEDCONTROL_GO					B00000000,B11110111,B10000101,B10110101,B10010101,B11110111,B00000000,B00000000
	#define EDU_LEDCONTROL_OK					B00000000,B11101001,B10101010,B10101100,B10101010,B11101001,B00000000,B00000000
	#define EDU_LEDCONTROL_PLUS					B00011000,B00011000,B00011000,B11111111,B11111111,B00011000,B00011000,B00011000
	#define EDU_LEDCONTROL_VALIDE				B00000000,B00000001,B00000011,B01000110,B01101100,B00111000,B00010000,B00000000
	#define EDU_LEDCONTROL_ATTENTION			B00111100,B01000010,B10011001,B10011001,B10000001,B10011001,B01000010,B00111100
	#define EDU_LEDCONTROL_PARKING 				B00000000,B00111000,B00100100,B00100100,B00111000,B00100000,B00100000,B00000000
	#define EDU_LEDCONTROL_10   				B00000000,B00100111,B01100101,B00100101,B00100101,B00100111,B00000000,B00000000
	#define EDU_LEDCONTROL_30 				    B00000000,B01110111,B00010101,B00110101,B00010101,B01110111,B00000000,B00000000
	#define EDU_LEDCONTROL_50   				B00000000,B01110111,B01000101,B01110101,B00010101,B01110111,B00000000,B00000000
	
	
	
	

//#include <___.h>
//#include "EDU_debug.h"

//#define DEBUG


class Duinoedu_LedControlExtend{

	public:
	
	/*EDU FR*/	Duinoedu_LedControlExtend();
	
	/*EDU FR*/	void brancher(int din, int cs, int clk);
	/*EDU US*/	void branch(int din, int cs, int clk);
	/*EDU FR*/	void brancher(int din, int cs, int clk, int num_disp);
	/*EDU US*/	void branch(int din, int cs, int clk, int num_disp);
	
	/*EDU FR*/	void afficherImage(byte L0, byte L1=B00000000, byte L2=B00000000, byte L3=B00000000, byte L4=B00000000, byte L5=B00000000, byte L6=B00000000, byte L7=B00000000);
	/*EDU US*/	void displayImage(byte L0, byte L1=B00000000, byte L2=B00000000, byte L3=B00000000, byte L4=B00000000, byte L5=B00000000, byte L6=B00000000, byte L7=B00000000);
	/*EDU FR*/	void afficherImage(int idisp, byte L0, byte L1=B00000000, byte L2=B00000000, byte L3=B00000000, byte L4=B00000000, byte L5=B00000000, byte L6=B00000000, byte L7=B00000000);
	/*EDU US*/	void displayImage(int idisp, byte L0, byte L1=B00000000, byte L2=B00000000, byte L3=B00000000, byte L4=B00000000, byte L5=B00000000, byte L6=B00000000, byte L7=B00000000);

	/*EDU FR*/	void afficherImage(const byte* icon);
	/*EDU US*/	void displayImage(const byte* icon);
	/*EDU FR*/	void afficherImage(int idisp, const byte* icon);
	/*EDU US*/	void displayImage(int idisp, const byte* icon);
	
	/*EDU FR*/	void afficherSequence(const byte seq[][8], const int nbrOfIcons);
	/*EDU US*/	void displaySequence(const byte seq[][8], const int nbrOfIcons);
	/*EDU FR*/	void afficherSequence(int, const byte seq[][8], const int nbrOfIcons);
	/*EDU US*/	void displaySequence(int,const byte seq[][8], const int nbrOfIcons);
	
	/*EDU FR*/	void incrementerSequence(const byte seq[][8], const int nbrOfIcons);
	/*EDU US*/	void stepSequence(const byte seq[][8], const int nbrOfIcons);
	
	/*EDU FR*/	void reglerDelais(uint16_t pause);
	/*EDU FR*/	void reglerDelais(int idisp, uint16_t pause);
	/*EDU US*/	void setDelay(uint16_t pause);
	/*EDU US*/	void setDelay(int idisp, uint16_t pause);

	
	/*EDU US*/	int16_t delayDuration[EDU_LEDCONTROL_MAXDISP];
		
	/*EDU US*/	LedControl *matrix;
	
	
	protected:
		int8_t m_sequenceIndex;
		int8_t m_numdisp;
		void __displayImage(int idisp, byte L0, byte L1, byte L2, byte L3, byte L4, byte L5, byte L6, byte L7);
	        void __displayImage(byte L0, byte, byte L2, byte L3, byte L4, byte L5, byte L6, byte L7);
		void __displayImageX(int idisp, const byte* icon);
		void __displaySequence(int idisp, const byte seq[][8], const int nbrOfIcons);
		void __stepSequence(int idisp, const byte seq[][8], const int nbrOfIcons);
		void __setDelay(int idisp, uint16_t pause);
		
};

class Duinoedu_LedControlAdd : public Duinoedu_LedControlExtend {
	public:


};


#endif
