#include <Wire.h>
#include <Adafruit_TCS34725.h>

Adafruit_TCS34725 tcs = Adafruit_TCS34725(TCS34725_INTEGRATIONTIME_700MS, TCS34725_GAIN_1X);

void getRawData_noDelay(uint16_t *r, uint16_t *g, uint16_t *b, uint16_t *c){
  *c = tcs.read16(TCS34725_CDATAL);
  *r = tcs.read16(TCS34725_RDATAL);
  *g = tcs.read16(TCS34725_GDATAL);
  *b = tcs.read16(TCS34725_BDATAL);
}


void setup() {
  Serial.begin(9600);
  while (!tcs.begin()) Serial.println("Color sensor not found");
  Serial.println ("I2C color ok"); 
}


void loop() {

    #define SP Serial.print
    
    // R G B
    static uint16_t r, g, b, c;
    getRawData_noDelay(&r, &g, &b, &c);
    SP(" R:"); SP(r);   SP(" G:"); SP(g);   SP(" B:"); SP(b);   SP(" C:"); SP(c);
    
    // Temperature de couleur
    static uint16_t colorTemp;
    colorTemp = tcs.calculateColorTemperature(r, g, b);
    SP(" Temp:"); SP(colorTemp);
    
    // Lux
    static uint16_t lux;
    lux = tcs.calculateLux(r, g, b);
    SP(" Lux:"); SP(lux);
    
    SP("\r\n");
}
