/*
  Reading CO2, humidity and temperature from the SCD30
  By: Nathan Seidle
  SparkFun Electronics
  Date: May 22nd, 2018
  License: MIT. See license file for more information but you can
  basically do whatever you want with this code.

  Feel like supporting open source hardware?
  Buy a board from SparkFun! https://www.sparkfun.com/products/14751

  This example demonstrates how to start the library using other Wire ports.

  Hardware Connections:
  Attach the Qwiic Shield to your Arduino/Photon/ESP32 or other
  Plug the sensor onto the shield
  Serial.print it out at 9600 baud to serial monitor.

  NOTE: THIS EXAMPLE WILL FAIL ON A DEVICE THAT ONLY HAS ONE WIRE INTERFACE

  Note: 100kHz I2C is fine, but according to the datasheet 400kHz I2C is not supported by the SCD30
*/

#include "paulvha_SCD30.h"

SCD30 airSensor;

void setup()
{
  Serial.begin(9600);
  Serial.println("SCD30 Example 3");

  // NOTE: THIS EXAMPLE WILL FAIL ON A DEVICE THAT ONLY HAS ONE WIRE INTERFACE

  Wire1.begin(); // Start the wire hardware that may be supported by your platform

  airSensor.begin(Wire1); // Pass the Wire port to the .begin() function

  //The library will now use Wire1 for all communication
}

void loop()
{
  if (airSensor.dataAvailable())
  {
    Serial.print("co2(ppm):");
    Serial.print(airSensor.getCO2());

    Serial.print(" temp(C):");
    Serial.print(airSensor.getTemperature(), 1);

    Serial.print(" humidity(%):");
    Serial.print(airSensor.getHumidity(), 1);

    Serial.println();
  }
  else
    Serial.print(".");

  delay(1000);
}

