/*
 
  Original Author: Karl THOMAS https://github.com/karlth
  
*/


#ifndef Duinoedu_Utility_SPIFFS_H
#define Duinoedu_Utility_SPIFFS_H
#include <Duinoedu_Esp8266.h>
#include <ESP8266WebServer.h>
#include "FS.h"

#ifdef ESP8266


void listESP8266(ESP8266WebServer & server){
	    uint32_t realSize = ESP.getFlashChipRealSize();  // specifique esp8266
  uint32_t ideSize = ESP.getFlashChipSize();
  FlashMode_t ideMode = ESP.getFlashChipMode();
  Serial.printf("Flash real id:   %08X\r\n", ESP.getFlashChipId());
  Serial.printf("Flash real size: %u\r\n", realSize);
  Serial.printf("Flash ide  size: %u\r\n", ideSize);
  Serial.printf("Flash ide speed: %u\r\n", ESP.getFlashChipSpeed());
  Serial.printf("Flash ide mode:  %s\r\n", (ideMode == FM_QIO ? "QIO" : ideMode == FM_QOUT ? "QOUT" : ideMode == FM_DIO ? "DIO" : ideMode == FM_DOUT ? "DOUT" : "UNKNOWN"));
  if(ideSize != realSize) {
      Serial.println("Flash Chip configuration wrong!");
  } else {
      Serial.println("Flash Chip configuration ok.");
  }
   
     FSInfo fs_info;   // que pour esp8266
     SPIFFS.info(fs_info); 

    Serial.print("Total FFS: ");
    Serial.print(fs_info.totalBytes/1024);
    Serial.println(" Ko");

    Serial.print("Libre FFS: ");
    Serial.print((fs_info.totalBytes - fs_info.usedBytes)/1024);
    Serial.println(" Ko");

    Serial.println("\nFichier(s):");
    Dir dir = SPIFFS.openDir("/");
    while (dir.next()) {
      Serial.print(dir.fileName());
      Serial.print("\t\t");
      File f = dir.openFile("r");
	  (&server)->serveStatic(f.name(), SPIFFS, f.name());
     // Serial.println(f.size());
     // f.close();                  //specifique esp8266
    }
    //(&server)->serveStatic("/", SPIFFS, "/"); //pour esp8266
}
void readFile(fs::FS &fs, const char * path){
    Serial.printf("Reading file: %s\r\n", path);

    File file = fs.open(path, "r");
    for(int i=0;i<file.size();i++)
  {
    Serial.print((char)file.read());    //Read file
  }
  file.close();
}

void writeFile(fs::FS &fs, const char * path, const char * message){
    Serial.printf("Writing file: %s\r\n", path);

    File file = fs.open(path,"w");
    if(!file){
        Serial.println("- failed to open file for writing");
        return;
    }
    if(file.print(message)){
        Serial.println("- file written");
    } else {
        Serial.println("- frite failed");
    }
}

void appendFile(fs::FS &fs, const char * path, const char * message){
    Serial.printf("Appending to file: %s\r\n", path);

    File file = fs.open(path, "a");
    if(!file){
        Serial.println("- failed to open file for appending");
        return;
    }
    if(file.print(message)){
        Serial.println("- message appended");
    } else {
        Serial.println("- append failed");
    }
}

#elif defined ESP32

#include "SPIFFS.h"

void listDir(fs::FS &fs, const char * dirname, uint8_t levels, ESP8266WebServer & server){
    Serial.printf("Listing directory: %s\r\n", dirname);

    File root = fs.open(dirname);
    if(!root){
        Serial.println("- failed to open directory");
        return;
    }
    if(!root.isDirectory()){
        Serial.println(" - not a directory");
        return;
    }

    File file = root.openNextFile();
    while(file){
        if(file.isDirectory()){
            Serial.print("  DIR : ");
            Serial.println(file.name());
            if(levels){
                listDir(fs, file.name(), levels -1, server );
            }
        } else {
            Serial.print("  FILE: ");
            Serial.print(file.name());
            Serial.print("\tSIZE: ");
            Serial.println(file.size());
        }
		

		(&server)->serveStatic(file.name(), SPIFFS, file.name()); //rend les fichiers de l'esp32 navigeable
        file = root.openNextFile();
    }
}

void readFile(fs::FS &fs, const char * path){
    Serial.printf("Reading file: %s\r\n", path);

    File file = fs.open(path);
    if(!file || file.isDirectory()){
        Serial.println("- failed to open file for reading");
        return;
    }

    Serial.println("- read from file:");
    while(file.available()){
        Serial.write(file.read());
    }
}

void writeFile(fs::FS &fs, const char * path, const char * message){
    Serial.printf("Writing file: %s\r\n", path);

    File file = fs.open(path, FILE_WRITE);
    if(!file){
        Serial.println("- failed to open file for writing");
        return;
    }
    if(file.print(message)){
        Serial.println("- file written");
    } else {
        Serial.println("- frite failed");
    }
}

void appendFile(fs::FS &fs, const char * path, const char * message){
    Serial.printf("Appending to file: %s\r\n", path);

    File file = fs.open(path, FILE_APPEND);
    if(!file){
        Serial.println("- failed to open file for appending");
        return;
    }
    if(file.print(message)){
        Serial.println("- message appended");
    } else {
        Serial.println("- append failed");
    }
}



#endif


void renameFile(fs::FS &fs, const char * path1, const char * path2){
    Serial.printf("Renaming file %s to %s\r\n", path1, path2);
    if (fs.rename(path1, path2)) {
        Serial.println("- file renamed");
    } else {
        Serial.println("- rename failed");
    }
}

void deleteFile(fs::FS &fs, const char * path){
    Serial.printf("Deleting file: %s\r\n", path);
    if(fs.remove(path)){
        Serial.println("- file deleted");
    } else {
        Serial.println("- delete failed");
    }
}

#endif