## Proposed changes
Describe the big picture of your changes here to communicate why we should accept this pull request. 
- If it fixes a bug or resolves a feature request, be sure to link to that issue. 
- If it introduces new functionality, why is this needed?
- If it modifies existing functionality, what makes this better?

## Types of changes
What types of changes does your code introduce?
Put an `x` in the boxes that apply
[ ] Bugfix (non-breaking change which fixes an issue)
[ ] New feature (non-breaking change which adds functionality)
[ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)

## Your Environment
**Library Version:** 
**Arduino IDE version:** 
**Hardware model/type:** 
**OS and Version:** 

## Checklist
Put an `x` in the boxes that apply. You can also fill these out after creating the PR.
This is a reminder of what we are expecting before merging your code.
[ ] Code compiles correctly/with no errors
[ ] I have added tests that prove my fix is effective or that my feature works
[ ] I have added or extended necessary documentation (if appropriate)
[ ] Any dependent changes have been merged and published in downstream modules

## Further comments
If this is a relatively large or complex change, kick off the discussion by explaining why you chose the solution you did and what alternatives you considered, etc...