#include <Duinoedu_Esp8266.h>
#include <DHT.h>


float temp;
float hum;
int compteur;
Duinoedu_Esp8266 MonEsp;
DHT dht_D2(D2,DHT11);
ESP8266WebServer server ( 80 );
String _Temperature_="";
String _Humidite_="";


//---------------------------------------------------------------------------------------------------

void handleRoot(){
  server.send ( 200, "text/html", getPage() );
  delay(10);
}

void startServer(){
  server.on ( "/", handleRoot );
  server.on ( "/xml", handleXML );
  server.begin();
  Serial.println ( "HTTP server started" );
}

void handleXML(){
  server.send(200,"text/xml",buildXML());
}

/*lecture de la température */
float get_temperature(DHT dht) {
  float t = dht.readTemperature();
  //Serial.println(t);
  return t;
}


/*lecture de l"humidité*/
float get_humidity(DHT dht) {
  float h = dht.readHumidity();
  //Serial.println(h);
  return h;
}



//---------------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------------
String buildXML(){
  String XML="<?xml version='1.0'?><inputs>";
  XML += "<_Temperature_>"+_Temperature_+"</_Temperature_>";
  XML += "<_Humidite_>"+_Humidite_+"</_Humidite_>";
  XML+="</inputs>";
  return XML;
 }

String buildJavascript(){
  String javaScript=MonEsp.javaScript_start();
  javaScript += "document.getElementById('v__Temperature_').innerHTML = this.responseXML.getElementsByTagName('_Temperature_')[0].childNodes[0].nodeValue;";
  javaScript += "gauge_Temperature_.value = this.responseXML.getElementsByTagName('_Temperature_')[0].childNodes[0].nodeValue;";
  javaScript += "document.getElementById('v__Humidite_').innerHTML = this.responseXML.getElementsByTagName('_Humidite_')[0].childNodes[0].nodeValue;";
  javaScript += "gauge_Humidite_.value = this.responseXML.getElementsByTagName('_Humidite_')[0].childNodes[0].nodeValue;";
  javaScript+=MonEsp.javaScript_end();
  return javaScript;
 }

String getPage(){
#define PAGE_EXIST
  String  page = "";
  page += "<!DOCTYPE html>";
  page += "<html>";
  page += "  <head>";
  page += "    <meta charset='utf-8'>";
  page += "    <meta http-equiv='Content-Type' content='text/html; charset=utf-8' />";
  page += "    <title>Collège des 2 sarres - Lorquin</title>";
  page += "    <style>";
  page += "     .class_0 {position:relative; left:20px; top:0px; height:350px; width:350px; float:left; background-color:#ffcc99; text-align:center; font-size:large; border:1px solid #000000;padding:5px;}";
  page += "     .class_1 {position:relative; left:20px; top:0px; height:350px; width:350px; float:left; background-color:#ccccff; text-align:center; font-size:large; border:1px solid #000000;padding:5px;}";
  page += "     .titre {font-size:x-large; font-style:normal; color:#000066; background-color:#ffff99; text-decoration:NONE; text-align:center;font-weight:bold; border:1px solid #000000;padding:5px;}";
  page += "     .materiel {font-size:medium; font-style:normal; color:#333333; background-color:#ffffff; text-decoration:NONE; text-align:center;padding:5px;}";
  page += "     .info {font-size:small; font-style:italic; color:#333399; background-color:#ffffff; text-decoration:NONE; text-align:center;padding:5px;}";
  page += "    </style>";
  page += "  </head>";
  page +=    MonEsp.addPhoneStyle() ;
  page += "  <body onload='process()'>";
  page += "    <p class='titre'>Mesures de température et d\'humidité</p>";
  page += "    <p class='materiel'>Capteur  : Grove - Temperature&Humidity Sensor</p>";
  page += "    <div class='class_0'>";
  page += "      <p class='info'>mesure effectuée toute les 2s</p>";
  page +=          buildJavascript();
    page += "        Température  = <a class=value id='v__Temperature_'></a> °C";
  page +=        buildJavascript();
    page +=        MonEsp.gauge(0,40,"_Temperature_");
  page += "    </div>";
  page += "    <div class='class_1'>";
  page += "      <p class='info'>mesure effectuée toute les 2s</p>";
  page +=          buildJavascript();
    page += "        Humidité  = <a class=value id='v__Humidite_'></a> %";
  page +=        buildJavascript();
    page +=        MonEsp.gauge(0,100,"_Humidite_");
  page += "    </div>";

  page += "    <style>";
  page += "      .value {font-size:large; font-style:normal; color:#3388ff;font-weight:bold; }";
  page += "    </style>";
  page += "  </body>";
  page += "  </html>";
  return page;
 }


//---------------------------------------------------------------------------------------------------
void setup() {

  //le mot de passe doit comporter 8 caractères ou plus
  MonEsp.connect_STA_smart("Driss Tel","driss57000");
  startServer();
  dht_D2.begin();
}

void loop() {
  compteur = 0;
  temp = 0;
  hum = 0;
  while (true) {
    if (compteur == 200) {
      temp = get_temperature(dht_D2);
      hum = get_humidity(dht_D2);
      compteur = 0;

    }
    compteur = compteur + 1;
    #ifdef PAGE_EXIST
      server.handleClient();
      delay(10);
    #endif
    delay(10);

      _Temperature_=String(temp);


      _Humidite_=String(hum);

  }

}
