 #ifndef Barbot_h
    #define Barbot_h
		#include "Arduino.h"
		#include <SoftwareSerial.h>
		#include "TZ51_TimerOne.h"
		
		
		
    class Barbot
    {
      public:
        Barbot();
        Barbot(float n1,float a1,int v1);
        void init();
		void move(unsigned int dir,unsigned int distance,unsigned int unite,unsigned int pre);
		void turn(unsigned int dir,unsigned int angle,unsigned int pre);
		void stop();
		bool IR_left;
		bool IR_right;
		bool IR_center;
		void IR38Write();
		void playTone(int freq, int duration);
		float step_per_dm=958.5;
		int vmax=253; 
		float step_per_degre=10.36;
		int LigLevel=260;
		void begin(uint32_t baud);
		String floatToString(float valeur,int precision);
		void SaveEEPROM(int slot);
		void change_RamStorage_size(int taille);
		void RestaureEEPROM(int slot);
		double* RamStorage;
		int RamStorage_size=0; 
      private:
	  union {
		double fval;
		byte bval[4];
		} floatAsBytes;
		SoftwareSerial * serial;  
	  unsigned int calcule_step(unsigned int dist,unsigned int unite);
		unsigned int calcule_angle(unsigned int angle); 
        
    };
        
#endif