#include "TZ51_IHM.h"

boolean time_out;

volatile boolean btnPress[] = {false,false,false,false,false,false,false,false,false,false};

volatile boolean interPress[] = {false,false,false,false,false,false,false,false,false,false};

volatile unsigned int potarVal[]={0,0,0,0,0,0,0,0,0,0};

volatile boolean intflag =false;

volatile boolean ihmflag = false;

TZ51_IHM::TZ51_IHM(SoftwareSerial * ss){
  serial = ss;
 }

void TZ51_IHM::begin(uint32_t baud){
  serial->begin(baud);
}

void TZ51_IHM::send(String s){
	serial->println(s);
}

void TZ51_IHM::sendcmd(String s1,String s2){
	serial->println(s1+s2);
}

void TZ51_IHM::sendcmd1(String s1,int n1){
	serial->println(s1+String(n1));
}

void TZ51_IHM::sendcmd2(String s1,String s2,String s3){
	serial->println(s1+s2+s3);
}

String TZ51_IHM::floatToString(float valeur,int precision){
  char charVal[10];
  String stringVal = "";
  float valc=valeur*pow(0.1,precision);
  for(int i=0;i<sizeof(charVal);i++)
    {
     charVal[i]=' ';
    }
  dtostrf(valc, 0, precision, charVal);
  //convert chararray to string
  for(int i=0;i<sizeof(charVal);i++)
    {
     if (charVal[i]!=' ') {stringVal+=charVal[i];}
    }
  //supprime le dernier caractère de strinVal
  stringVal=stringVal.substring(0,stringVal.length()-1);
  return stringVal;
}

int TZ51_IHM::lire_octet() {
 time_out=false;
 byte counter=0;
 while(serial->available()==0 && !time_out) {
  counter+=1;
  delayMicroseconds(1000); // wait 1 ms
  if (counter>100) {time_out=true;} //time_out + watchdog !
 }
 if (!time_out) { return serial->read(); } else { return -1; }
}

int TZ51_IHM::bt_read() {
 stringOne = "";
 if (serial->available()>0) {
   int carac;
   time_out=false;
   do {
      carac=lire_octet();
      if ((carac!=10)&(carac!=38)&(carac!=13)){stringOne+=char(carac);}
     }
   while ((carac!=10)&(carac!=38)&(!time_out));
   if (time_out) {
      stringOne="";
      return 0;
   }
   return 1;
  }
 return 0;
}

int TZ51_IHM::available() {
 stringOne = "";
 serial->println("|P");
 delay(300);
 if (TZ51_IHM::bt_read()>0) {
  if (stringOne=="OK") {
     Timer1.start();
     return 1;
  } else {
     return 0;
  }
 } else {
 return 0;
 }
}

unsigned long hex2int(String a, unsigned int len) {
 int i;
 unsigned long val = 0;
 for(i=0;i<len;i++)
   if(a[i] <= 57)
    val += (a[i]-48)*(1<<(4*(len-1-i)));
   else
    val += (a[i]-55)*(1<<(4*(len-1-i)));
 return val;
}

boolean isValidNumber(String str){
 boolean temp=true;
 for(byte i=0;i<str.length();i++) {
    if(!isDigit(str.charAt(i))) { temp=false; }
 }
 return temp;
}

void TZ51_IHM::BTinterrupt() {
 if (!intflag) {
    intflag=true;
    if (serial->available()>0) {
       if (bt_read()>0) {
          if (stringOne[0] == 'B') {
             int decValue = hex2int(stringOne.substring(1),1)-1;
             btnPress[decValue]=true;
             ihmflag=true;
          } else if (stringOne[0] == 'I') {
             int decValue = hex2int(stringOne.substring(1,2),1)-1;
             if (stringOne[2]=='1') {
                interPress[decValue]=true;
                ihmflag=true;
             } else {
                interPress[decValue]=false;
                ihmflag=true;
             }
         } else if (stringOne[0] == 'P') {
           int decValue = hex2int(stringOne.substring(1,2),1)-1;
           if (isValidNumber(stringOne.substring(2))) {
               potarVal[decValue]=stringOne.substring(2).toInt();
               ihmflag=true;
           }
         }else {
            stringOne=""; //On vide la chaine de réception
         }
      } else {
         stringOne=""; //On vide la chaine de réception
      }
    }
    intflag=false;
 }
}


boolean TZ51_IHM::change() {
 if (ihmflag) {
  ihmflag=false;
  return 1;
 } else {
  return 0;
 }
}

boolean TZ51_IHM::testBtn(int num) {
 Timer1.stop();
 if (btnPress[num-1]) {
  btnPress[num-1]=false;
  Timer1.resume();
  return 1;
 } else {
  Timer1.resume();
  return 0;
 }
}

boolean TZ51_IHM::testInter(int num) {
 Timer1.stop();
 if (interPress[num-1]) {
   Timer1.resume();
   return 1;
 } else {
   Timer1.resume();
   return 0;
 }
}

unsigned int TZ51_IHM::readPotar(int num) {
 return potarVal[num-1];
}