#include "TZ51_BiSerial.h"
#include "TZ51_Rfid.h"

void TZ51_RFID::begin(int broche){
  pin=broche;
  reponse="";
  int nb=0;
  //On teste la communication avec le module RFID en envoyant "ping"
  while (reponse!=F("pong")&&nb<10) {
	 Sendcmd(pin,F("ping"));
	 reponse=recieverRunMaster(pin);
	 nb+=1;
  }
}

bool TZ51_RFID::card_present(){
  Sendcmd (pin,F("card"));
  reponse=recieverRunMaster(pin);
  if (reponse==F("YES")) {
	  return true;
  } else {
	  return false;
  }
}

void TZ51_RFID::write(int sector,String s){
  cmd="write "+String(sector)+" "+s;	
  Sendcmd (pin,cmd);
  reponse=recieverRunMaster(pin);
}

void TZ51_RFID::write(int sector,float n){
  cmd="write "+String(sector)+" "+String(n);  
  Sendcmd (pin,cmd);
  reponse=recieverRunMaster(pin);
}

void TZ51_RFID::read(int sector){
  cmd="read "+String(sector);
  Sendcmd(pin,cmd);
  reponse=recieverRunMaster(pin);
}