#include "TZ51_WF.h"

boolean time_out;

volatile boolean btnPress[] = {false,false,false,false,false,false,false,false,false,false};

volatile boolean interPress[] = {false,false,false,false,false,false,false,false,false,false};

volatile unsigned int potarVal[]={0,0,0,0,0,0,0,0,0,0};

volatile boolean intflag =false;

volatile boolean ihmflag = false;

TZ51_WF::TZ51_WF(SoftwareSerial * ss){
  serial = ss;
 }

void TZ51_WF::begin(uint32_t baud){
  serial->begin(baud);
}

void TZ51_WF::send(String s){
	serial->println(s);
}

String floatToString(float valeur,int precision){
  char charVal[10];
  String stringVal = "";
  float valc=valeur*pow(0.1,precision);
  for(int i=0;i<sizeof(charVal);i++)
    {
     charVal[i]=' ';
    }
  dtostrf(valc, 0, precision, charVal);
  //convert chararray to string
  for(int i=0;i<sizeof(charVal);i++)
    {
     if (charVal[i]!=' ') {stringVal+=charVal[i];}
    }
  //supprime le dernier caractère de strinVal
  stringVal=stringVal.substring(0,stringVal.length()-1);
  return stringVal;
}

int TZ51_WF::lire_octet() {
 time_out=false;
 byte counter=0;
 while(serial->available()==0 && !time_out) {
  counter+=1;
  delayMicroseconds(1000); // wait 1 ms
  if (counter>100) {time_out=true;} //time_out + watchdog !
 }
 if (!time_out) { return serial->read(); } else { return -1; }
}

int TZ51_WF::bt_read() {
 stringOne = "";
 if (serial->available()>0) {
   int carac;
   time_out=false;
   do {
      carac=lire_octet();
      if ((carac!=10)&(carac!=38)&(carac!=13)){stringOne+=char(carac);}
     }
   while ((carac!=10)&(carac!=38)&(!time_out));
   if (time_out) {
      stringOne="";
      return 0;
   }
   return 1;
  }
 return 0;
}

int TZ51_WF::ihm_available() {
 stringOne = "";
 serial->println("|P");
 delay(300);
 if (TZ51_WF::bt_read()>0) {
  if (stringOne=="OK") {
     Timer1.start();
     return 1;
  } else {
     return 0;
  }
 } else {
 return 0;
 }
}

unsigned long hex2int(String a, unsigned int len) {
 int i;
 unsigned long val = 0;
 for(i=0;i<len;i++)
   if(a[i] <= 57)
    val += (a[i]-48)*(1<<(4*(len-1-i)));
   else
    val += (a[i]-55)*(1<<(4*(len-1-i)));
 return val;
}

boolean isValidNumber(String str){
 boolean temp=true;
 for(byte i=0;i<str.length();i++) {
    if(!isDigit(str.charAt(i))) { temp=false; }
 }
 return temp;
}


void TZ51_WF::fetch_cmd(){
 //Serial.print("In fetch_cmd : ");
 int eq=stringwf.indexOf("=");
 if (eq!=-1) {
  //On a intercepté un changement d'un field
  field_no=stringwf.substring(1,eq);
  //Serial.print(field_no);
  //Serial.print("=");
  field_value=stringwf.substring(eq+1);
  field_value.replace("\n","");
  field_value.replace("\r","");
  //Serial.print(field_value);
  //Serial.println(".");
  wf_enabled=true;
 } else {
  //on a intercepté un ordre inconnue
  field_no="";
  field_value="";
  wf_enabled=false;
 }
}
void TZ51_WF::WFwaitAcq(){
  time_out=false;	
  byte counter=0;
  while (!wf_enabled && !time_out) {
	  //on attends 1 ms 
	  delay(1);
	  counter+=1;
	  if (counter>5000) {time_out=true;} //time_out 
	  };
  wf_enabled=false; 
}

void TZ51_WF::WFinterrupt() {
 if (!intflag) {
  intflag=true;
  if (serial->available()>0) {
          // read the incoming byte:
              incomingByte = serial->read();
              if (incomingByte==10) {
                TZ51_WF::fetch_cmd();
                stringwf="";
              } else {
              stringwf+=char(incomingByte);
			  //Serial.print(char(incomingByte));
              }
  }
  intflag=false;
 }
}

void TZ51_WF::cmd_led(int n1,int n2){
 String stemp="";
 switch (n2) {
  case 0:
    stemp="none";
    // statements
    break;
  case 1:
    stemp="red";
    // statements
    break;
  case 2:
    stemp="orange";
    // statements
    break;
  case 3:
    stemp="yellow";
    // statements
    break;
  case 4:
    stemp="green";
    // statements
    break;
  case 5:
    stemp="blue";
    // statements
    break;	
}	
 //On réinitialise l'attente de message
 //wf_enabled=false;
 serial->println("write "+String(n1)+" "+stemp);
}

void TZ51_WF::cmd_btn(int n1,int n2){
 String stemp="";
 switch (n2) {
  case 0:
    stemp="false";
    // statements
    break;
  case 1:
    stemp="true";
    // statements
    break;
}	
 serial->println("write "+String(n1)+" "+stemp);	
}

void TZ51_WF::cmd_potar(int n1,int n2){
 serial->println("write "+String(n1)+" "+String(n2));	
}

void TZ51_WF::init_module(int n1,String s_ssid,String s_passwd,String s_ipserver,String s_ipgateway,String s_ipsubnet,int n2){
 digitalWrite(13,LOW);
 delay(10000); 
 serial->println("serverip "+s_ipserver);
 delay(1500);
 serial->println("gatewayip "+s_ipgateway);
 delay(1500);
 serial->println("subnetip "+s_ipsubnet);
 delay(1500);
 serial->println("ssid "+s_ssid);
 delay(1500);
 serial->println("passwd "+s_passwd);
 delay(1500);
 switch (n1) {
	 case 0:
			serial->println("mode AP");
			delay(1500);
			break;
	 case 1:
			serial->println("mode STA");
			delay(1500);
			break;
 }
 switch (n2) {
	 case 0:
			serial->println("verbose off");
			delay(1500);
			break;
	 case 1:
			serial->println("verbose on");
			delay(1500);
			break;
 } 
 serial->println("store");
 delay(1500);
 serial->println("reset");
 delay(30000);
 digitalWrite(13,HIGH);
 while (1) {}
}

void TZ51_WF::cmd_label(int n1,String s2){
 serial->println("write "+String(n1)+" "+s2);
}

void TZ51_WF::cmd_log(int n1,String s2){
 serial->println("log "+String(n1)+" "+s2);	
}

void TZ51_WF::cmd_clear_log(int n1){
 String s1=String(n1);
 s1.replace("\n","");
 s1.replace("\r","");
 serial->println("delete /log"+s1+".txt"+char(10));
}

void TZ51_WF::set_resolution(int n1){
 String s1=String(n1);
 s1.replace("\n","");
 s1.replace("\r","");
 serial->println("resolution "+s1+char(10));
}

void TZ51_WF::shoot(int n1){
 String s1=String(n1);
 s1.replace("\n","");
 s1.replace("\r","");
 wf_enabled=false;
 serial->println("shoot "+s1+char(10));	
}

boolean TZ51_WF::test_field(int n1,int n2){
 String s1="";
 switch (n2) {
	 case 1:
	   s1="true";
	   break;
	 case 0:
	   s1="false";
	   break;
 }
 return (field_no==String(n1)&&field_value.startsWith(s1,0));
}

boolean TZ51_WF::test_potar(int n1){
 wf_enabled=false;	
 return (field_no==String(n1));
}

boolean ihm_change() {
 if (ihmflag) {
  ihmflag=false;
  return 1;
 } else {
  return 0;
 }
}