#ifndef TZ51_wifi
#define TZ51_wifi

#include "Arduino.h"
#include <SoftwareSerial.h>
#include "TZ51_TimerOne.h"

class TZ51_WF {
  private:
  SoftwareSerial * serial;  
  void fetch_cmd();
  boolean time_out;
  int incomingByte = 0;
  volatile boolean intflag =false;
  public:
    TZ51_WF(SoftwareSerial * ss);
    void begin(uint32_t baud);
    int lire_octet();
    int bt_read();
	void send(String s);
    int ihm_available();
    void WFinterrupt();
	void WFwaitAcq();
	void cmd_led(int n1,int n2);
	void cmd_btn(int n1,int n2);
	void cmd_potar(int n1,int n2);
	void cmd_label(int n1,String s2);
	void init_module(int n1,String s_ssid,String s_passwd,String s_ipserver,String s_ipgateway,String s_ipsubnet,int n2);
	void cmd_log(int n1,String s2);
	void cmd_clear_log(int n1);
	void set_resolution(int n1);
	void shoot(int n1);
	boolean test_field(int n1,int n2);
	boolean test_potar(int n1);
    String stringOne = "";
	boolean wf_enabled=false;
    String stringwf = "";
	String field_no = "";
	String field_value = "";
    // other prototypes
};

    
#endif