//blink 1
//Exemple de tâche avec une fonction setup() et une fonction loop()

#include "ordonnanceur.h"

#define pinLed1 13

/*******************************************************************/
/* tache 1                                                         */
/*******************************************************************/
void setup_t1();
tache t1(setup_t1, 1000);

void setup_t1()
{
  Serial_print_millis();
  pinMode(pinLed1, OUTPUT);
  digitalWrite(pinLed1, HIGH);
  Serial.println("ON");
  t1.changerFonction(loop_t1);
}

void loop_t1()
{
  static uint8_t etat = HIGH;
  Serial_print_millis();
  etat = (etat == HIGH) ? LOW : HIGH;
  digitalWrite(pinLed1, etat);
  Serial.println(etat == HIGH ? "ON" : "OFF");
}

/*******************************************************************/
/* fonction principales                                            */
/*******************************************************************/

void setup()
{
  Serial.begin(115200);
  ordonnanceur.lancer();
}

void loop() {}

void Serial_print_millis()
{
  Serial.print("millis()=");
  Serial_print_int(millis(), 8);
  Serial.print(", ");
}

void Serial_print_int(uint32_t nombre, uint8_t nb_chiffres)
{
  uint32_t puissancedix = 1;
  for (uint8_t i=1; i<nb_chiffres; i++) puissancedix *= 10;
  while (puissancedix > nombre && puissancedix > 1)
  {
    Serial.print('0');
    puissancedix /= 10;
  }
  Serial.print(nombre);
}