//blink 3
//Exemple de tâche avec une alternance de périodes

#include "ordonnanceur.h"

#define pinLed3 13

/*******************************************************************/
/* tache 3                                                         */
/*******************************************************************/
void setup_t3();
tache t3(setup_t3, 500);

void setup_t3()
{
  Serial_print_millis();
  pinMode(pinLed3, OUTPUT);
  digitalWrite(pinLed3, HIGH);
  Serial.println("ON");
  t3.changerFonction(loop_t3);
}

void loop_t3()
{
  static uint8_t etat = HIGH;
  Serial_print_millis();
  if (etat == HIGH)
  {
    etat = LOW;
    Serial.println("OFF");
    t3.changerPeriode(1000);
  }
  else
  {
    etat = HIGH;
    Serial.println("ON");
    t3.changerPeriode(500);
  }
  digitalWrite(pinLed3, etat);
}

/*******************************************************************/
/* fonction principales                                            */
/*******************************************************************/

void setup()
{
  Serial.begin(115200);
  ordonnanceur.lancer();
}

void loop() {}

void Serial_print_millis()
{
  Serial.print("millis()=");
  Serial_print_int(millis(), 8);
  Serial.print(", ");
}

void Serial_print_int(uint32_t nombre, uint8_t nb_chiffres)
{
  uint32_t puissancedix = 1;
  for (uint8_t i=1; i<nb_chiffres; i++) puissancedix *= 10;
  while (puissancedix > nombre && puissancedix > 1)
  {
    Serial.print('0');
    puissancedix /= 10;
  }
  Serial.print(nombre);
}