//blink multiple
//Fusion des exemples blink 1 + blink 2 + blink 3

#include "ordonnanceur.h"

#define pinLed1 13
#define pinLed2 5
#define pinLed3 6

/*******************************************************************/
/* tache 1                                                         */
/*******************************************************************/
void setup_t1();
tache t1(setup_t1, 1000);

void setup_t1()
{
  Serial_print_millis();
  pinMode(pinLed1, OUTPUT);
  digitalWrite(pinLed1, HIGH);
  Serial.println("  ON");
  t1.changerFonction(loop_t1);
}

void loop_t1()
{
  static uint8_t etat = HIGH;
  Serial_print_millis();
  etat = (etat == HIGH) ? LOW : HIGH;
  digitalWrite(pinLed1, etat);
  Serial.println(etat == HIGH ? "  ON" : "  OFF");
}

/*******************************************************************/
/* tache 2                                                         */
/*******************************************************************/
void setup_t2();
tache t2(setup_t2, 1500);

void setup_t2()
{
  Serial_print_millis();
  pinMode(pinLed2, OUTPUT);
  digitalWrite(pinLed2, HIGH);
  Serial.println("         ON");
  t2.changerFonction(loop_t2a);
}

void loop_t2a()
{
  Serial_print_millis();
  digitalWrite(pinLed2, LOW);
  Serial.println("         OFF");
  t2.changerFonction(loop_t2b);
}

void loop_t2b()
{
  Serial_print_millis();
  digitalWrite(pinLed2, HIGH);
  Serial.println("         ON");
  t2.changerFonction(loop_t2a);
}

/*******************************************************************/
/* tache 3                                                         */
/*******************************************************************/
void setup_t3();
tache t3(setup_t3, 500);

void setup_t3()
{
  Serial_print_millis();
  pinMode(pinLed3, OUTPUT);
  digitalWrite(pinLed3, HIGH);
  Serial.println("                 ON");
  t3.changerFonction(loop_t3);
}

void loop_t3()
{
  static uint8_t etat = HIGH;
  Serial_print_millis();
  if (etat == HIGH)
  {
    etat = LOW;
    Serial.println("                OFF");
    t3.changerPeriode(1000);
  }
  else
  {
    etat = HIGH;
    Serial.println("                ON");
    t3.changerPeriode(500);
  }
  digitalWrite(pinLed3, etat);
}

/*******************************************************************/
/* fonction principales                                            */
/*******************************************************************/

void setup()
{
  Serial.begin(115200);
  Serial.println("                   BLINK1 BLINK2 BLINK3");
  ordonnanceur.lancer();
}

void loop() {}

void Serial_print_millis()
{
  Serial.print("millis()=");
  Serial_print_int(millis(), 8);
  Serial.print(", ");
}

void Serial_print_int(uint32_t nombre, uint8_t nb_chiffres)
{
  uint32_t puissancedix = 1;
  for (uint8_t i=1; i<nb_chiffres; i++) puissancedix *= 10;
  while (puissancedix > nombre && puissancedix > 1)
  {
    Serial.print('0');
    puissancedix /= 10;
  }
  Serial.print(nombre);
}