//Test de la charge CPU
#include "ordonnanceur.h"

//Ici on simule deux tâches ayant une durée d'exécution prédéfinie,
//pour vérifier que le calcul de la charge CPU est correct

//Paramètres (modifier pour jouer)
const uint32_t periode_tache1 = 1000;
const uint32_t duree_tache1   =  200;

const uint32_t periode_tache2 = 5000;
const uint32_t duree_tache2   =  500;

uint32_t nbt1 = 0;
uint32_t nbt2 = 0;

//Tâches

void affichage();
tache taff(affichage, 1000);
void affichage()
{
  //Affichage de la charge CPU
  Serial_print_millis();
  Serial.print("nbt1=");
  Serial_print_int(nbt1, 4);
  Serial.print(", nbt2=");
  Serial_print_int(nbt2, 4);
  Serial.print(", CPU1s=");
  Serial_print_int(ordonnanceur.chargeCPU1s(), 3);
  Serial.print("%, CPU5s=");
  Serial_print_int(ordonnanceur.chargeCPU5s(), 3);
  Serial.println('%');
}

void loop1();
tache t1(loop1, periode_tache1);

void loop1()
{
  uint32_t debut = millis();
  nbt1++;
  while (millis() - debut < duree_tache1);
}

void loop2();
tache t2(loop2, periode_tache2);

void loop2()
{
  uint32_t debut = millis();
  nbt2++;
  while (millis() - debut < duree_tache2);
}

void setup()
{
  Serial.begin(115200);
  Serial.println("\nLancement programme");
  Serial.println("Lancement ordonnanceur");
  ordonnanceur.lancer();
}

void loop() {}

void Serial_print_millis()
{
  Serial.print("millis()=");
  Serial_print_int(millis(), 8);
  Serial.print(", ");
}

void Serial_print_int(uint32_t nombre, uint8_t nb_chiffres)
{
  uint32_t puissancedix = 1;
  for (uint8_t i=1; i<nb_chiffres; i++) puissancedix *= 10;
  while (puissancedix > nombre && puissancedix > 1)
  {
    Serial.print('0');
    puissancedix /= 10;
  }
  Serial.print(nombre);
}