//Test d'arret de l'ordonnanceur
#include "ordonnanceur.h"

void loop1();
tache t1(loop1, 1000);
void loop1()
{
  static uint8_t compteur_appels = 0;

  Serial_print_millis();
  compteur_appels++;
  Serial.print("Nb exec=");
  Serial.println(compteur_appels);
  if (compteur_appels > 9)
  {
    Serial.println("Arret de l'ordonnanceur...");
    ordonnanceur.stopper();
  }
}

void setup()
{
  Serial.begin(115200);
  Serial.println("\nLancement programme");
  Serial.println("Lancement ordonnanceur");
  ordonnanceur.lancer(WATCHDOG_1_SECONDE);
  Serial.println("Ordonnanceur arrete");
  Serial.println("Attente 10 secondes pour verifier que le watchdog est inactif...");
  delay(10000);
  Serial.println("Fin programme");
}

void loop() {}

void Serial_print_millis()
{
  Serial.print("millis()=");
  Serial_print_int(millis(), 8);
  Serial.print(", ");
}

void Serial_print_int(uint32_t nombre, uint8_t nb_chiffres)
{
  uint32_t puissancedix = 1;
  for (uint8_t i=1; i<nb_chiffres; i++) puissancedix *= 10;
  while (puissancedix > nombre && puissancedix > 1)
  {
    Serial.print('0');
    puissancedix /= 10;
  }
  Serial.print(nombre);
}