//Démonstration avec des tâches de fond

#include "ordonnanceur.h"

/*******************************************************************/
/* taches de fond = tâches avec une période nulle                  */
/*******************************************************************/
void loop1();
tache t1(loop1, 0);
uint32_t nb_t1 = 0;
void loop1() {nb_t1++;}

tache t2(loop2, 0);
uint32_t nb_t2 = 0;
void loop2() {nb_t2++;}

/*******************************************************************/
/* tache standard                                                  */
/*******************************************************************/

//La tâche standard est déclenchée chaque seconde
//Elle affiche le nombre d'exécutions des tâches de fond

void loop3();
tache t3(loop3, 1000);
void loop3()
{
  //Permet de vérifier que la période de 1000 ms est bien respectée
  //malgré le brouhaha des tâches de fond.
  Serial_print_millis();
  
  //Permet de vérifier que l'ordonnanceur répartit équitablement
  //les exécutions entre plusieurs tâches de fond similaires.
  Serial.print("nb_t1=");
  Serial_print_int(nb_t1, 8);
  Serial.print(", nb_t2=");
  Serial_print_int(nb_t2, 8);
  
  //Permet de vérifier que l'arduino est bien occupé à 100% de ses capacités
  Serial.print(", CPU1s=");
  Serial_print_int(ordonnanceur.chargeCPU1s(), 3);
  Serial.print("%, CPU5s=");
  Serial_print_int(ordonnanceur.chargeCPU5s(), 3);
  Serial.println('%');
}

/*******************************************************************/
/* fonction principales                                            */
/*******************************************************************/

void setup()
{
  Serial.begin(115200);
  ordonnanceur.lancer();
}

void loop() {}

void Serial_print_millis()
{
  Serial.print("millis()=");
  Serial_print_int(millis(), 8);
  Serial.print(", ");
}

void Serial_print_int(uint32_t nombre, uint8_t nb_chiffres)
{
  uint32_t puissancedix = 1;
  for (uint8_t i=1; i<nb_chiffres; i++) puissancedix *= 10;
  while (puissancedix > nombre && puissancedix > 1)
  {
    Serial.print('0');
    puissancedix /= 10;
  }
  Serial.print(nombre);
}