'use strict';

goog.provide('Blockly.Arduino.lists');

goog.require('Blockly.Arduino');


Blockly.Arduino.lists_create_with = function() {
  // Create a list with any number of elements of any type.
  var dropdown_type = this.getTitleValue('TYPE');
  var varName = Blockly.Arduino.variableDB_.getName(this.getTitleValue('VAR'),
      Blockly.Variables.NAME_TYPE);
  var size=window.parseFloat(this.getTitleValue('SIZE'));
  var code = new Array(this.itemCount_);
  for (var n = 0; n < this.itemCount_; n++) {
    code[n] = Blockly.Arduino.valueToCode(this, 'ADD' + n,
        Blockly.Arduino.ORDER_NONE) || '0';
  }
  Blockly.Arduino.definitions_['var_lists'+varName] = dropdown_type+' '+varName+'['+size+']'+'='+ '{' + code.join(', ') + '};\n';
  //var code =''+varName+'['+size+"]"+'='+ '{' + code.join(', ') + '};\n';
  //Blockly.Arduino.setups_['setup_lists'+varName] = code;
  return '';
};

Blockly.Arduino.lists_create_with_text = function() {
  var dropdown_type = this.getTitleValue('TYPE');
  var varName = Blockly.Arduino.variableDB_.getName(this.getTitleValue('VAR'),
      Blockly.Variables.NAME_TYPE);
  var size=window.parseFloat(this.getTitleValue('SIZE'));
  var text=this.getTitleValue('TEXT');
  Blockly.Arduino.definitions_['var_lists'+varName] = dropdown_type+' '+varName+'['+size+']'+'='+ '{' + text + '};\n';
  return '';
};

Blockly.Arduino.lists_create_with2 = function() {
  // Create a list with any number of elements of any type.
  var dropdown_type = this.getTitleValue('TYPE');
  var varName = Blockly.Arduino.variableDB_.getName(this.getTitleValue('VAR'),
      Blockly.Variables.NAME_TYPE);
  //var size=window.parseFloat(this.getTitleValue('SIZE'));
  var code = new Array(this.itemCount_);
  for (var n = 0; n < this.itemCount_; n++) {
    code[n] = Blockly.Arduino.valueToCode(this, 'ADD' + n,
        Blockly.Arduino.ORDER_NONE) || '0';
  }
  Blockly.Arduino.definitions_['var_lists'+varName] = dropdown_type+' '+varName+'[]'+'='+ '{' + code.join(', ') + '};\n';
  //var code =''+varName+'['+size+"]"+'='+ '{' + code.join(', ') + '};\n';
  //Blockly.Arduino.setups_['setup_lists'+varName] = code;
  return '';
};

Blockly.Arduino.lists_create_with_text2 = function() {
  var dropdown_type = this.getTitleValue('TYPE');
  var varName = Blockly.Arduino.variableDB_.getName(this.getTitleValue('VAR'),
      Blockly.Variables.NAME_TYPE);
  //var size=window.parseFloat(this.getTitleValue('SIZE'));
  var text=this.getTitleValue('TEXT');
  Blockly.Arduino.definitions_['var_lists'+varName] = dropdown_type+' '+varName+'[]'+'='+ '{' + text + '};\n';
  return '';
};

Blockly.Arduino.lists_getIndex = function() {
  // Indexing into a list is the same as indexing into a string.
  var varName = Blockly.Arduino.variableDB_.getName(this.getTitleValue('VAR'),
      Blockly.Variables.NAME_TYPE);
  var argument0 = Blockly.Arduino.valueToCode(this, 'AT',
      Blockly.Arduino.ORDER_ADDITIVE) || '1';
  if (argument0.match(/^\d+$/)) {
    // If the index is a naked number, decrement it right now.
    argument0 = parseInt(argument0, 10) - 1;
  } else {
    // If the index is dynamic, decrement it in code.
    argument0 += ' - 1';
  }
  var code=varName+'[(int)('+argument0+')]';
  return [code,Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino.lists_setIndex = function() {
  // Set element at index.
  var varName = Blockly.Arduino.variableDB_.getName(this.getTitleValue('VAR'),
      Blockly.Variables.NAME_TYPE);
  var argument0 = Blockly.Arduino.valueToCode(this, 'AT',
      Blockly.Arduino.ORDER_ADDITIVE) || '1';
  var argument2 = Blockly.Arduino.valueToCode(this, 'TO',
      Blockly.Arduino.ORDER_ASSIGNMENT) || '0';
  // Blockly uses one-based indicies.
  if (argument0.match(/^\d+$/)) {
    // If the index is a naked number, decrement it right now.
    argument0 = parseInt(argument0, 10) - 1;
  } else {
    // If the index is dynamic, decrement it in code.
    argument0 += ' - 1';
  }
  return varName + '[(int)(' + argument0 + ')] = ' + argument2 + ';\n';
};

Blockly.Arduino.lists_length = function() {
  var varName = Blockly.Arduino.variableDB_.getName(this.getTitleValue('VAR'),
      Blockly.Variables.NAME_TYPE);
  var code='sizeof('+varName+')/sizeof('+varName+'[0])';
  return [code,Blockly.Arduino.ORDER_ATOMIC];
};